#version 300 es

#define MAX_BONES 200
precision highp float;
in vec3 aPosition;
in vec3 aColor;
in vec3 aNormal;
in vec3 aTangent;
in vec2 aUV;

//4 selected bones, aligned to the mesh like color is.
in vec4 aBoneWeights;
in uvec4 aBoneIndices;
uniform sampler2D uBMnSKdata;

uniform mat4 uM; //model matrix
uniform mat4 uMVP; //model,view,projection.
uniform float time;

out vec3 vColor;
out vec2 vUV;
out vec3 vNormal;
out vec3 vPosition;
out vec3 vTangent;
out vec3 vWPosition;

mat4 GetBoneMatrix(uint index)
{
    mat4 boneMat;
    for (int i = 0; i < 4; i++ )
    {
        int texelIndex = int(index) * 4 + i;
        
        int x = texelIndex % 128;
        int y = texelIndex / 128;

        vec2 uv = (vec2(x, y) + 0.5) / vec2(128);

        vec4 rgba = textureLod(uBMnSKdata, uv, 0.0f);

        boneMat[i][0] = rgba.r; // GLSL mat4 is column-major
        boneMat[i][1] = rgba.g; // GLSL mat4 is column-major
        boneMat[i][2] = rgba.b; // GLSL mat4 is column-major
        boneMat[i][3] = rgba.a; // GLSL mat4 is column-major
    }
    return boneMat;
}

void main() 
{
    mat4 skinMatrix =
        aBoneWeights.x * GetBoneMatrix(aBoneIndices.x) +
        aBoneWeights.y * GetBoneMatrix(aBoneIndices.y) +
        aBoneWeights.z * GetBoneMatrix(aBoneIndices.z) +
        aBoneWeights.w * GetBoneMatrix(aBoneIndices.w);

    gl_Position = uMVP * skinMatrix * vec4(aPosition, 1.0);    

    vColor = aColor;
    vUV = aUV;

    mat3 normalMatrix = transpose(inverse(mat3(uM)));

    vec4 skinnedNormal = skinMatrix * vec4(aNormal, 0.0);
    vNormal = normalize(normalMatrix * skinnedNormal.xyz);

    vec4 skinnedTangent = skinMatrix * vec4(aTangent, 0.0);
    vTangent = normalize(normalMatrix * skinnedTangent.xyz);

    vPosition = (uMVP * vec4(aPosition, 1.0)).xyz;
    vWPosition = (uM * vec4(aPosition, 1.0)).xyz;
}